package mcfall.raytracer;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AdvancedOptions extends JFrame {
	AdvancedOptions self = this;
	private static final int MAX_SUBS = 64;
	private final AdvancedInfomation tracerWindowInformation;
	private JButton closeButton, acceptButton;
	private JSlider gridsX, gridsY;
	private JTextField maxRecursions;
	private JTextField maxThreads;
	public AdvancedOptions(AdvancedInfomation tracerwindow ) {
		super("Advanced Options");
		this.tracerWindowInformation=tracerwindow;
		closeButton = new JButton("Close");
		closeButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				dispose();				
			}
		});
		acceptButton = new JButton("Accept");
		acceptButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				tracerWindowInformation.setGridSubsX(gridsX.getValue());
				tracerWindowInformation.setGridSubsY(gridsY.getValue());
				try {
					if(maxThreads.getText().length()!=0) {
						tracerWindowInformation.setMaxThreads(Integer.parseInt(maxThreads.getText()));
					}
					if(maxRecursions.getText().length()!=0) {
						tracerWindowInformation.setMaxRecursions(Integer.parseInt(maxRecursions.getText()));
					}
				} catch (NumberFormatException ex) {}
				dispose();
			}
		});
		gridsX = new JSlider(JSlider.HORIZONTAL, 1,MAX_SUBS,tracerWindowInformation.getGridSubsX());
		gridsX.setMajorTickSpacing(8);
		gridsX.setMinorTickSpacing(2);
		gridsX.setPaintLabels(true);
		gridsX.setPaintTicks(true);
		gridsX.addChangeListener(new MaxThreadsUpdater());
		gridsY = new JSlider(JSlider.HORIZONTAL, 1,MAX_SUBS,tracerWindowInformation.getGridSubsY());
		gridsY.setMajorTickSpacing(8);
		gridsY.setMinorTickSpacing(2);
		gridsY.setPaintLabels(true);
		gridsY.setPaintTicks(true);
		gridsY.addChangeListener(new MaxThreadsUpdater());
		
		maxThreads = new JTextField(""+tracerWindowInformation.getMaxThreads());
		maxThreads.addKeyListener(new MaxThreadsUpdater());
		
		maxRecursions = new JTextField(""+tracerWindowInformation.getMaxRecursions());
		
		GridBagLayout gridLayout = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		
		this.setLayout(gridLayout);
		c.weightx=0.5;c.fill=GridBagConstraints.HORIZONTAL;
		this.add(new JLabel("Number of vertical subdivisions"),c);
		c.gridx = 1;
		this.add(gridsX,c);
		
		c.gridx = 0;c.gridy = 1;
		this.add(new JLabel("Number of horizontal subdivisions"),c);
		c.gridx = 1;
		this.add(gridsY,c);
		
		c.gridx = 0;c.gridy = 2;
		this.add(new JLabel("Maximum number of threads"),c);
		c.gridx = 1;
		this.add(maxThreads,c);
		
		c.gridx = 0; c.gridy=3;
		this.add(new JLabel("Maximum number of recursions"),c);
		c.gridx = 1;
		this.add(maxRecursions,c);
		
		c.gridx = 0;c.gridy = 4;
		this.add(closeButton,c);
		c.gridx = 1;
		this.add(acceptButton,c);
		this.pack();
		this.setVisible(true);
	}
	

	private class MaxThreadsUpdater implements ChangeListener, KeyListener {
		public void stateChanged(ChangeEvent e) {
			maxThreadsCheck();				
		}

		private void maxThreadsCheck() {
			if(maxThreads.getText().length()>0){
				int max=0;
				try {
					max = Integer.parseInt(maxThreads.getText());
				} catch (NumberFormatException ex) {
					max = tracerWindowInformation.getMaxThreads();
				}
				maxThreads.setText(""+Math.min(max, gridsX.getValue()*gridsY.getValue()));
			}
		}

		public void keyPressed(KeyEvent e) {
			// TODO Auto-generated method stub			
		}

		public void keyReleased(KeyEvent e) {
			// TODO Auto-generated method stub			
		}

		public void keyTyped(KeyEvent e) {
			maxThreadsCheck();
		}
	}
	
}
